/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.configs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.SyncConfigsPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ConfigHandler {
    public static Predicate<Object> STRING_CHECK = o -> o instanceof String;
    public static Predicate<Object> LIST_STRING_CHECK = o -> o instanceof List && ((Collection)o).stream().allMatch(s -> s instanceof String);

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ConfigHandler::onPlayerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(ConfigHandler::onPlayerLoggedOut);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigHandler::reloadConfigsEvent);
    }

    public static <T> void resetConfigValue(ForgeConfigSpec spec, ForgeConfigSpec.ConfigValue<T> value) {
        ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(value.getPath());
        if (valueSpec == null) {
            Supplementaries.LOGGER.throwing((Throwable)new Exception("No such config value: " + value + "in config " + spec));
        }
        value.set(valueSpec.getDefault());
    }

    public static <T> T safeGetListString(ForgeConfigSpec spec, ForgeConfigSpec.ConfigValue<T> value) {
        Object o = value.get();
        try {
            Object object = o;
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn((Object)new Exception("Resetting erroneous config value: " + value + "in config " + spec));
            ConfigHandler.resetConfigValue(spec, value);
        }
        return (T)value.get();
    }

    public static void reloadConfigsEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == ServerConfigs.SERVER_SPEC) {
            ConfigHandler.syncServerConfigs();
            ServerConfigs.cached.refresh();
        } else if (event.getConfig().getSpec() == ClientConfigs.CLIENT_SPEC) {
            ClientConfigs.cached.refresh();
        }
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            ConfigHandler.syncServerConfigs(event.getPlayer());
        }
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            ServerConfigs.loadLocal();
            ServerConfigs.cached.refresh();
        }
    }

    public static Path getServerConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("supplementaries-common.toml").toAbsolutePath();
    }

    public static void syncServerConfigs() {
        PlayerList playerList;
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null && (playerList = currentServer.func_184103_al()) != null) {
            for (ServerPlayerEntity player : playerList.func_181057_v()) {
                ConfigHandler.syncServerConfigs((PlayerEntity)player);
            }
        }
    }

    public static void syncServerConfigs(PlayerEntity player) {
        try {
            byte[] configData = Files.readAllBytes(ConfigHandler.getServerConfigPath());
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SyncConfigsPacket(configData));
        }
        catch (IOException e) {
            Supplementaries.LOGGER.error("supplementaries: Failed to sync common configs", (Throwable)e);
        }
    }

    public static class CachedConfigValue<T, C extends ForgeConfigSpec.ConfigValue<T>> {
        private T cached;
        private final C config;

        public CachedConfigValue(C config) {
            this.config = config;
            this.refresh();
        }

        public T get() {
            return this.cached;
        }

        public void refresh() {
            this.cached = this.config.get();
        }
    }
}

